import PyIPSDK
import PyIPSDK.IPSDKIPLBinarization as bin
import PyIPSDK.IPSDKIPLGlobalMeasure as glbmsr
import PyIPSDK.IPSDKIPLAdvancedMorphology as advmorpho

from UsefullWidgets import Measure

def My_function(inImg1):
	output = []

	if inImg1.getSizeZ() == 1:
		nbLabels = glbmsr.statsMsr2d(inImg1).max
	else:
		nbLabels = glbmsr.statsMsr3d(inImg1).max

	for i in range(1,int(nbLabels)+1):

		maskImg = bin.thresholdImg(inImg1,i,i)
		if inImg1.getSizeZ() == 1:
			connectedImg = advmorpho.connectedComponent2dImg(maskImg)
			output.append(glbmsr.statsMsr2d(connectedImg).max)
		else:
			connectedImg = advmorpho.connectedComponent3dImg(maskImg)
			output.append(glbmsr.statsMsr3d(connectedImg).max)

	measure = Measure()
	measure.subType = "Counting"
	measure.value = output

	return measure
